package main

import (
	"github.com/veandco/go-sdl2/sdl"
)

type RotateAnimation struct {
	sprite *Sprite
	angle  float64
	speed  float64
}

func NewRotateAnimation(renderer *sdl.Renderer, surface *sdl.Surface, speed float64) *RotateAnimation {
	anim := new(RotateAnimation)
	anim.angle = 0.0
	anim.speed = speed
	anim.sprite = NewSprite(renderer, surface)
	return anim
}

func (a *RotateAnimation) Update(renderer *sdl.Renderer, deltaTime float32) {
	a.angle += a.speed * float64(deltaTime)
	if a.angle > 360.0 {
		a.angle -= 360.0
	} else if a.angle < 0.0 {
		a.angle += 360.0
	}
}

func (a *RotateAnimation) Draw(renderer *sdl.Renderer, x int32, y int32) {
	a.sprite.RotateAndDraw(renderer, a.angle, x, y)
}

func (a *RotateAnimation) Width() int32 {
	return a.sprite.Width()
}

func (a *RotateAnimation) Height() int32 {
	return a.sprite.Height()
}
